/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________ *
*  Copyright 2010-2021 Adobe
*  All Rights Reserved.
* * NOTICE:  All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/

// Header defining the interface for tangent space plugins (version 1.0)
// Note: This interface replicates almost function for function the one defined
// in mikktspace.h (version 1.0) by Morten S. Mikkelsen
// The main differences are:
// - plugins are only required to be able to process triangles
// - plugins only compute normalized tangents and the orientation sign
// - some functions names and types were renamed for genericity

#ifndef __TANGENTSPACEPLUGIN_H__
#define __TANGENTSPACEPLUGIN_H__

// This version number is required by the getAPIVersion() function
#define TSPACE_API_VERSION 0x00010001 // Major | Minor

/* C/C++ macros */
#ifndef SUBSTANCE_EXTERNC
#	ifdef __cplusplus
#		define SUBSTANCE_EXTERNC extern "C"
#	else
#		define SUBSTANCE_EXTERNC
#	endif
#endif

/* SUBSTANCE_EXPORT macros */
#ifndef SUBSTANCE_EXPORT
#	ifdef SUBSTANCE_DLL
#		if defined(_MSC_VER) || defined(__INTEL_COMPILER)
#			define SUBSTANCE_EXPORT SUBSTANCE_EXTERNC __declspec(dllexport)
#		elif defined(__GNUC__)
#			if __GNUC__ >= 4
#				define SUBSTANCE_EXPORT SUBSTANCE_EXTERNC __attribute__((visibility("default")))
#			else
#				define SUBSTANCE_EXPORT SUBSTANCE_EXTERNC
#			endif
#		else
#			error Unknown compiler
#		endif
#	else
#		define SUBSTANCE_EXPORT SUBSTANCE_EXTERNC
#	endif
#endif

/* Callback functions */
#ifndef SUBSTANCE_CALLBACK
#	if defined(_MSC_VER) || defined(__INTEL_COMPILER)
#		define SUBSTANCE_CALLBACK __stdcall
#	else
#		define SUBSTANCE_CALLBACK
#	endif
#endif

#ifdef __cplusplus
SUBSTANCE_EXTERNC
{
#endif

	typedef struct TSpacePluginContext TSpacePluginContext;

	typedef struct
	{
		// Returns the number of faces (triangles) on the mesh to be processed.
		int(SUBSTANCE_CALLBACK* mGetNumFaces)(void* userData);

		// returns the position/normal/texcoord of the referenced face of vertex
		// number vert.
		// vert is in the range {0,1,2}.
		void(SUBSTANCE_CALLBACK*
				 mGetPosition)(void* userData, float posOut[], const int face, const int vert);
		void(SUBSTANCE_CALLBACK*
				 mGetNormal)(void* userData, float normOut[], const int face, const int vert);
		void(SUBSTANCE_CALLBACK*
				 mGetTexCoord)(void* userData, float texcOut[], const int face, const int vert);

		// This function is used to return the tangent and sign to the application.
		// tangent is a unit length vector.
		// For normal maps it is sufficient to use the following simplified version
		// of the bitangent which is generated at fragment/vertex level.
		// bitangent = sign * cross(vN, tangent);
		// Note that the results are returned unindexed.
		void(SUBSTANCE_CALLBACK* mSetTSpace)(
			void* userData,
			const float tangent[],
			const float sign,
			const int face,
			const int vert);

	} TSpacePluginInterface;

	struct TSpacePluginContext
	{
		TSpacePluginInterface* mInterface; // initialized with callback functions
		void* mUserData;                   // pointer to client side mesh data etc.
		// (passed as the first parameter with every interface call)
	};

	// This function should compute the tangent space using the callbacks and data
	// passed within the context structure
	SUBSTANCE_EXPORT int generateTangentSpace(
		const TSpacePluginContext* context, const float angularThreshold);

	// This function should return TSPACE_API_VERSION
	// It is used by the application to check which version of the API the plugin
	// was build with.
	SUBSTANCE_EXPORT unsigned int getAPIVersion();

	// This function should return a pointer to an UTF8-encoded c-string containing
	// a label that can be used as a human-readable name label for this plugin in
	// the host application.
	// This pointer must remain valid as long as the plugin is loaded
	SUBSTANCE_EXPORT const char* getLabel();

	// This function should return a pointer to an UTF8-encoded c-string containing
	// a short description of this plugin for use in the host application (e.g. as
	// a tooltip).
	// This pointer must remain valid as long as the plugin is loaded.
	SUBSTANCE_EXPORT const char* getDescription();

	// This function should return the GLSL code to use for the per fragment
	// interpolation of the tangent. This must define the body of a function
	// taking 3 inout parameters (normal, tangent, bitangent) and possibly
	// modifying those parameters (e.g renormalizing or reorthogonalizing).
	// This pointer must remain valid as long as the plugin is loaded.
	SUBSTANCE_EXPORT const char* getTangentBasisInterpolation();

#ifdef __cplusplus
}
#endif

#endif // defined __TANGENTSPACEPLUGIN_H__
